﻿using System;
using System.ComponentModel;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using Microsoft.SharePoint.Administration;
using Microsoft.SharePoint.WebControls;


namespace LokaleListen.LokaleListen
{
   [ToolboxItemAttribute(false)]
   public class LokaleListen : WebPart
   {
      private bool _Error;
      private SPGridView _GridView;

      protected override void CreateChildControls()
      {
         try
         {
            // add the datasource
            var dataSource = new SPDataSource();
            dataSource.DataSourceMode = SPDataSourceMode.ListOfLists;
            Controls.Add(dataSource);

            // add menu template
            var menu = new MenuTemplate {ID = "ListMenu", CompactMode = true};
            ControlCollection menuItems = menu.Controls;
            menuItems.Add(new MenuItemTemplate {Text = "Zur Liste gehen", ClientOnClickNavigateUrl = "%URL%"});
            menuItems.Add(new MenuItemTemplate {Text = "Einstellungen der Liste", ClientOnClickNavigateUrl = "%WEBURL%/_layouts/listedit.aspx?List=%ID%"});
            Controls.Add(menu);

            // create the SPGridView
            _GridView = new SPGridView
                           {
                              DataSource = dataSource,
                              AutoGenerateColumns = false
                           };
            Controls.Add(_GridView);

            // add columns to the SPGridView
            var titleField = new SPMenuField
                                {
                                   MenuTemplateId = menu.ID,
                                   HeaderText = "Titel",
                                   TextFields = "__spTitle",
                                   NavigateUrlFields = "__spRootFolderUrl",
                                   NavigateUrlFormat = "{0}",
                                   // add tokens, so we can use them in the menu later
                                   TokenNameAndValueFields = "WEBURL=__spParentWebUrl,URL=__spRootFolderUrl,ID=__spID"
                                };
            _GridView.Columns.Add(titleField);
            var createdField = new SPBoundField
                                  {
                                     HeaderText = "Erstellt",
                                     DataField = "__spCreated"
                                  };
            _GridView.Columns.Add(createdField);
         }
         catch (Exception ex)
         {
            HandleException(ex);
         }
      }

      protected override void OnPreRender(EventArgs e)
      {
         base.OnPreRender(e);
         try
         {
            if (_Error) return;
            _GridView.DataBind();
         }
         catch (Exception ex)
         {
            HandleException(ex);
         }
      }

      private void HandleException(Exception ex)
      {
         _Error = true;
         Controls.Clear();
         Controls.Add(new Label
         {
            CssClass = "ms-error",
            Text = ex.Message
         });
         var category = new SPDiagnosticsCategory("Web Part Name", TraceSeverity.High, EventSeverity.Error);
         SPDiagnosticsService.Local.WriteTrace(0,
                                                category,
                                                TraceSeverity.High,
                                                "{0}", ex.Message);
      #if DEBUG
         // only show the StackTrace, if the Web Part was compiled in debug mode
         Controls.Add(new Label
         {
            CssClass = "ms-error",
            Text = ex.StackTrace
         });
         SPDiagnosticsService.Local.WriteTrace(0,
                                                category,
                                                TraceSeverity.High,
                                                "{0}", ex.StackTrace);
      #endif
      }
   }
}
